/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jtbcore.exception.InvalidStateException;

public class HttpTransferHelper {
    protected long timeout = -1L;
    protected long contentLength = -1L;

    public HttpTransferHelper() {
    }

    public HttpTransferHelper(long timeout_msec) {
        this.timeout = timeout_msec;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void copyChunk(File f, OutputStream os) throws InvalidStateException, NumberFormatException, IOException, InterruptedException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
            this.copyChunk(is, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void copyChunk(InputStream is, OutputStream os) throws InvalidStateException, NumberFormatException, IOException, InterruptedException {
        int chunklen = -1;
        Object chunklenOctets = "";
        int r = 0;
        byte b = 0;
        byte prevb = 0;
        boolean endReached = false;
        long lastRead = System.currentTimeMillis();
        do {
            r = 0;
            int avail = is.available();
            int cnt = 0;
            while (cnt < avail) {
                r = is.read();
                b = (byte)r;
                if (chunklen > 0) {
                    --chunklen;
                }
                if (chunklen == -1) {
                    if (b != 13 && b != 10) {
                        chunklenOctets = (String)chunklenOctets + b;
                    }
                    if (((String)chunklenOctets).length() > 10) {
                        throw new InvalidStateException("Invalid chunk size");
                    }
                    if (prevb == 13 && b == 10) {
                        chunklen = Integer.parseInt(((String)chunklenOctets).trim(), 8);
                        chunklenOctets = "";
                        if (chunklen == 0) {
                            os.write(r);
                            endReached = true;
                            break;
                        }
                    }
                }
                os.write(r);
                prevb = b;
                if (chunklen == 0) {
                    chunklen = -1;
                }
                ++cnt;
            }
            if (avail > 0) {
                lastRead = System.currentTimeMillis();
            }
            if (r != 0) continue;
            if (System.currentTimeMillis() - lastRead > this.timeout) {
                throw new IOException("Relay timeout");
            }
            Thread.sleep(100L);
        } while (!endReached && r != -1);
        os.flush();
        os.close();
    }

    public void copyStream(InputStream is, File f) throws InvalidStateException, NumberFormatException, IOException, InterruptedException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));){
            this.copyStream(is, (OutputStream)bos);
            ((OutputStream)bos).flush();
            ((OutputStream)bos).close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void copyStream(File f, OutputStream os) throws InvalidStateException, NumberFormatException, IOException, InterruptedException {
        this.setContentLength(f.length());
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
            this.copyStream((InputStream)is, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void copyStream(InputStream is, OutputStream os) throws IOException, InterruptedException {
        int bytesRead = 0;
        long lastRead = System.currentTimeMillis();
        int r = -1;
        byte[] buf = new byte[4096];
        do {
            int avail = is.available();
            r = 0;
            if (avail > 0 && (r = is.read(buf, 0, 4096)) > 0) {
                bytesRead += r;
                lastRead = System.currentTimeMillis();
                os.write(buf, 0, r);
            }
            if (this.contentLength > 0L && (long)bytesRead >= this.contentLength) break;
            if (r != 0) continue;
            if (System.currentTimeMillis() - lastRead > this.timeout) {
                throw new IOException("Relay timeout");
            }
            Thread.sleep(100L);
        } while (r != -1);
    }
}

